package com.mobiuz.app.dev.ui.settings.safety.pin

import android.os.Bundle
import android.view.View
import android.widget.TextView
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentNewPinBinding
import com.mobiuz.app.databinding.FragmentOldPinBinding
import com.mobiuz.app.databinding.FragmentPinBinding
import com.mobiuz.app.dev.model.PinData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.auth.pin.PinAdapter
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.utils.Utils
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import javax.inject.Inject

@AndroidEntryPoint
class NewPinFragment : BaseFragment(R.layout.fragment_new_pin) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentNewPinBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    private val data = ArrayList<PinData>()
    private val pinAdapter = PinAdapter()


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentNewPinBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            loadData()
            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
            rvPin.layoutManager = LinearLayoutManager(requireContext(), LinearLayoutManager.HORIZONTAL, false)
            rvPin.setHasFixedSize(true)

            rvPin.adapter = pinAdapter

            txtNotPin.isVisible = false

            pinAdapter.setOnDoneListener {
                lifecycleScope.launchWhenCreated {
                    delay(50)
                    navController.navigate(R.id.confirmNewPinFragment, bundleOf("pinCode" to it), Utils.navOptions())
                }
            }

            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
            for (i in 0 until btnViewGroup.childCount) {
                btnViewGroup.getChildAt(i).setOnClickListener {
                    when (it.id) {
                        R.id.btn_remove -> {
                            pinAdapter.removeItem()
                        }
                        R.id.btn_forget_pin -> {

                        }
                        else -> {
                            val text = it as TextView
                            pinAdapter.addItem(text.text.toString().toInt())
                        }
                    }
                }
            }

        }
    }

    private fun loadData() {
        data.clear()
        for (i in 0..3) {
            data.add(PinData(-1))
        }
        pinAdapter.submitList(data)
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}