package com.mobiuz.app.dev.ui.home

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.mobiuz.app.dev.network.model.Customer
import com.mobiuz.app.dev.network.model.UiStateObject
import com.mobiuz.app.dev.network.repository.AuthRepository
import com.mobiuz.app.dev.network.repository.MainRepository
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import javax.inject.Inject

@HiltViewModel
class HomeViewModel @Inject constructor(
    private val repository: MainRepository
) : ViewModel() {

    private val _mainIndexUiState = MutableStateFlow<UiStateObject<Customer>>(UiStateObject.EMPTY)
    val mainIndexUiState: StateFlow<UiStateObject<Customer>> = _mainIndexUiState

    fun mainIndex() = viewModelScope.launch {
        _mainIndexUiState.value = UiStateObject.LOADING
        _mainIndexUiState.value = repository.mainIndex()
    }

    suspend fun logOut() = repository.logOut()

}