package com.mobiuz.app.dev.ui.service

import android.os.Bundle
import android.view.View
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.lifecycle.ViewModelProvider
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentServiceBinding
import com.mobiuz.app.dev.MainViewModel
import com.mobiuz.app.dev.model.ServiceData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.ui.global.CONSTANTS
import dagger.hilt.android.AndroidEntryPoint
import me.everything.android.ui.overscroll.OverScrollDecoratorHelper
import javax.inject.Inject

@AndroidEntryPoint
class ServiceFragment : BaseFragment(R.layout.fragment_service) {

    @Inject
    lateinit var pref: SharedPref
    private lateinit var mainViewModel: MainViewModel
    private var _bn: FragmentServiceBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var adapter: ServiceAdapter
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    var type = ""

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        mainViewModel = ViewModelProvider(requireActivity())[MainViewModel::class.java]
        adapter = ServiceAdapter(pref.language)
        arguments?.let {
            type = it.getString(CONSTANTS.TYPE_SERVICE) ?: ""

        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentServiceBinding.bind(view)
        setUpUI()
        collects()

        val window = requireActivity().window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR

    }

    override fun onResume() {
        super.onResume()
        mainViewModel.bottomSheet(true)
        mainViewModel.swipeDrawer(true)
    }


    override fun setUpUI() {
        bn.apply {

            if (type == CONSTANTS.OFFLINE) {
                toolbar.isVisible = false
                txtDostupno.isVisible = true
                layoutOffline.isVisible = true
            }

            rvService.adapter = adapter
//            rvService.edgeEffectFactory = RecyclerView.EdgeEffectFactory()

            val arg = pref.services
            val list = Gson().fromJson<List<ServiceData>>(arg, object : TypeToken<List<ServiceData>>() {}.type)
            adapter.submitList(list)

            OverScrollDecoratorHelper.setUpStaticOverScroll(bn.rvService, OverScrollDecoratorHelper.ORIENTATION_VERTICAL)
            adapter.setOnClickListener {
                navigateToServiceScreen(it)
            }

            toolbar.setNavigationOnClickListener {
                mainViewModel.mainIndex(System.currentTimeMillis())
            }
        }
    }

    override fun onStop() {
        super.onStop()
        mainViewModel.swipeDrawer(false)
    }


    private fun navigateToServiceScreen(key: ServiceData) {
        navController.navigate(R.id.servicesFragmentActivity, bundleOf(CONSTANTS.SERVICE to Gson().toJson(key)))
        mainViewModel.bottomSheet(false)
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}