package com.mobiuz.app.dev.ui.settings

import android.content.Intent
import android.graphics.Color
import android.os.Bundle
import android.view.View
import androidx.appcompat.app.AppCompatActivity
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import com.mobiuz.app.R
import com.mobiuz.app.databinding.ActivitySettingsBinding
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.auth.AuthActivity
import com.mobiuz.app.dev.ui.global.CONSTANTS
import com.mobiuz.app.dev.ui.global.FullScreenDialog
import com.mobiuz.app.dev.utils.LocaleHelper
import dagger.hilt.android.AndroidEntryPoint
import javax.inject.Inject

@AndroidEntryPoint
class SettingsActivity : AppCompatActivity() {

    private var _bn: ActivitySettingsBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private lateinit var navController: NavController

    @Inject
    lateinit var pref: SharedPref

    override fun onCreate(savedInstanceState: Bundle?) {
        LocaleHelper.setLocale(this)

        super.onCreate(savedInstanceState)
        _bn = ActivitySettingsBinding.inflate(layoutInflater)
        setContentView(bn.root)
        window.statusBarColor = Color.WHITE
        val window = window.decorView
        window.systemUiVisibility = window.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
        val fragment = supportFragmentManager.findFragmentById(R.id.settings_container) as NavHostFragment
        navController = NavHostFragment.findNavController(fragment)

        intent?.let {
            when (it.getStringExtra(CONSTANTS.TYPE_SETTINGS)) {
                CONSTANTS.PROFILE -> {
                    navController.popBackStack()
                    navController.navigate(R.id.profileFragment)

                }

                CONSTANTS.SUPPORT -> {
                    navController.popBackStack()
                    navController.navigate(R.id.supportFragment)

                }
                CONSTANTS.SAFETY -> {
                    navController.popBackStack()
                    navController.navigate(R.id.safetyFragment)

                }
                else -> Unit
            }
        }
    }

    override fun onResume() {
        super.onResume()
        if(pref.isShowPin){
            showPinCode()
        }else{
            pref.isShowPin = true
        }
    }

    private fun showPinCode() {
        intent?.let {
            val arg = it.getStringExtra(CONSTANTS.FIRST) ?: ""
            if (arg.isEmpty()) {
                val dialog = FullScreenDialog()
                dialog.setOnPinDoneListener {
                    finish()
                    pref.clearUserData()
                    val intent = Intent(this, AuthActivity::class.java)
                    intent.flags = Intent.FLAG_ACTIVITY_NEW_TASK or Intent.FLAG_ACTIVITY_TASK_ON_HOME
                    startActivity(intent)
                    dialog.dismiss()
                }
                dialog.show(supportFragmentManager, "tag")
            }
            it.removeExtra(CONSTANTS.FIRST)
        }
    }

    override fun onDestroy() {
        pref.isShowPin = false
        _bn = null
        super.onDestroy()
    }

}