package com.mobiuz.app.dev.ui.settings.safety.pin

import android.graphics.Color
import android.os.Bundle
import android.view.View
import android.view.animation.AnimationUtils
import android.widget.TextView
import androidx.core.view.isVisible
import androidx.lifecycle.lifecycleScope
import androidx.navigation.NavController
import androidx.navigation.fragment.NavHostFragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.mobiuz.app.R
import com.mobiuz.app.databinding.FragmentConfirmNewPinBinding
import com.mobiuz.app.dev.model.PinData
import com.mobiuz.app.dev.model.SharedPref
import com.mobiuz.app.dev.ui.auth.pin.PinAdapter
import com.mobiuz.app.dev.ui.base.BaseFragment
import com.mobiuz.app.dev.utils.extensions.getColorCompat
import com.mobiuz.app.dev.utils.extensions.showMessage
import dagger.hilt.android.AndroidEntryPoint
import kotlinx.coroutines.delay
import javax.inject.Inject

@AndroidEntryPoint
class ConfirmNewPinFragment : BaseFragment(R.layout.fragment_confirm_new_pin) {

    @Inject
    lateinit var pref: SharedPref
    private var _bn: FragmentConfirmNewPinBinding? = null
    private val bn get() = _bn ?: throw NullPointerException("cannot inflate")
    private val navController: NavController by lazy(LazyThreadSafetyMode.NONE) { NavHostFragment.findNavController(this) }
    private var pinCode = ""
    private val data = ArrayList<PinData>()
    private val pinAdapter = PinAdapter()
    private lateinit var decorView: View

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            pinCode = it.getString("pinCode", "") ?: ""
        }
    }


    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        _bn = FragmentConfirmNewPinBinding.bind(view)

        setUpUI()
        collects()

    }

    override fun setUpUI() {
        bn.apply {
            loadData()
            rvPin.layoutManager = LinearLayoutManager(requireContext(), LinearLayoutManager.HORIZONTAL, false)
            rvPin.setHasFixedSize(true)

            rvPin.adapter = pinAdapter
            pinAdapter.setOnDoneListener {
                lifecycleScope.launchWhenCreated {
                    delay(50)
                    if (pinCode == it) {
                        navigate()
                    } else {
                        cardPin.startAnimation(AnimationUtils.loadAnimation(requireContext(), R.anim.shake))
                        loadError(true)
                    }
                }

            }

            toolbar.setNavigationOnClickListener {
                navController.navigateUp()
            }
            for (i in 0 until btnViewGroup.childCount) {
                btnViewGroup.getChildAt(i).setOnClickListener {
                    when (it.id) {
                        R.id.btn_remove -> {
                            loadError(false)
                            pinAdapter.removeItem()
                        }
                        R.id.btn_forget_pin -> {

                        }
                        else -> {
                            loadError(false)
                            val text = it as TextView
                            pinAdapter.addItem(text.text.toString().toInt())
                        }
                    }
                }
            }

        }
    }

    private fun loadError(status: Boolean) {
        bn.apply {
            errorLayout.isVisible = status
            div.setBackgroundColor(if (status) getColorCompat(R.color.primary100) else Color.TRANSPARENT)
            decorView = requireActivity().window.decorView
            decorView.systemUiVisibility = if (status) View.VISIBLE else {
                decorView.systemUiVisibility or View.SYSTEM_UI_FLAG_LIGHT_STATUS_BAR
            }
        }
    }

    private fun navigate() {
        showMessage(getString(R.string.pin_code_updated))
        navController.popBackStack(R.id.safetyFragment, false)
    }

    private fun loadData() {
        data.clear()
        for (i in 0..3) {
            data.add(PinData(-1))
        }
        pinAdapter.submitList(data)
    }

    override fun collects() {

    }

    override fun onDestroy() {
        _bn = null
        super.onDestroy()
    }
}